program Astroid;
uses Graph;

const FiStart = 0;      //Piesimo pradzia (radianais)
const FiEnd = 2 * Pi;   //Piesimo pabaiga (radianais)
const Inc = 0.002;      //Tasku tankumas (kuo didesnis tuo didesni tarpai tarp tasku)
const OffsetX = 400;    //Astroido atitraukimas nuo kaires
const OffsetY = 400;    //Astroido atitraukimas nuo virsaus
const R = 100;          //Astroido dydis
const Color = 2;        //Astroido spalva
const Size = trunc((FiEnd-FiStart)*(1/Inc)) + 1;   //Masyvo dydis reikalingas astroido taskams saugoti

{
Tasko ekrane struktura
}
type Dot = record
    x, y: integer;
end;

{
Visu tasku masyvas
}
type DotArray = array[1..Size] of Dot;

{
Funkcija skaiciuojanti kiekvieno astroido tasko x koordinate
}
function GetX(fi: real): real;
var c: real;
begin
    c := Cos(fi);
    GetX := 2.0 * c * c * c;
end;

{
Funkcija skaiciuojanti kiekvieno astroido tasko y koordinate
}
function GetY(fi: real): real;
var s: real;
begin
    s := Sin(fi);
    GetY := 2.0 * s * s * s;
end;

{
Procedura nupiesianti horizontalia ir vertikalia linijas
}
procedure DrawLines;
begin
    Line(0, OffsetY, 2 * OffsetX, OffsetY);
    Line(OffsetX, 0, OffsetX, 2 * OffsetY);
end;

{
Procedura nupiesianti astroida
Veikimas:
Perbegami visi taskai nuo FiStart iki FiEnd ir suskaiciuojamos
ju koordinates x ir y. Koordinates skaiciuojamos kvieciant atitinkamas funckijas
ir pridedant poslinki nuo apacios ir virsaus, kad figura butu norimoje vietoje.
Apskaiciuoti taskai sudedami i masyva.
Poto visi apskaiciuoti taskai nupiesiami ekrane.
}
procedure DrawAstroid;
var fi: real;
    i: integer;
    da: DotArray;
begin
    fi := FiStart;
    i := 1;         //i nurodo kelinta taska skaiciuojame
    while fi < FiEnd do
    begin
        da[i].x := OffsetX + round(R * GetX(fi));   //x koordinates skaiciavimas
        da[i].y := OffsetY + round(R * GetY(fi));   //y koordinates skaiciavimas
        i := i + 1;                                 //pereinam prie sekancio tasko
        fi := fi + Inc;
    end;
    //Atskiras ciklas taskam nupiesti
    for i := 1 to Size do
        PutPixel(da[i].x, da[i].y, Color);
end;

{
Pagrindine programa
}
var GD, GM: integer;
begin
  InitGraph(GD,GM,'');      //Paleidziame grafikos posistemi
  DrawLines;                //Nupiesiame linija
  DrawAstroid;              //Nupiesiame astroida
  ReadLn;                   //Laukiam kol bus paspaustas klavisas, kad programa pati iskart neuzsidarytu
  CloseGraph;               //Uzdarome grafikos posistemi
end.

Z*o5xpbmZw	_(d jypƸ 7#